package editor;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;

import javax.sound.sampled.Clip;

import editor.RoomEditorPanel.SpawnPointAndDepth;


public class RadioLoadData {
	
	private ArrayList<SpawnPointAndDepth> spawnPoints;
	private String waveFile;
	private String caption;
	private Color captionColor;
	private Clip soundClip;
	
	
	public RadioLoadData() {
		spawnPoints = new ArrayList<SpawnPointAndDepth>();
	}
	
	public String getWaveFile() {
		return waveFile;
	}
	public void setWaveFile(String waveFile) {
		this.waveFile = waveFile;
	}
	public String getCaption() {
		return caption;
	}
	public void setCaption(String caption) {
		this.caption = caption;
	}
	public Color getCaptionColor() {
		return captionColor;
	}
	public void setCaptionColor(Color captionColor) {
		this.captionColor = captionColor;
	}
	public ArrayList<SpawnPointAndDepth> getSpawnPoints() {
		return spawnPoints;
	}
	
	
	
	public Clip getSoundClip() {
		return soundClip;
	}

	public void setSoundClip(Clip soundClip) {
		this.soundClip = soundClip;
	}

	public void addSpawnPoint(SpawnPointAndDepth p) {
		int spawnPointsSize = spawnPoints.size();
		
		for(int i = 0; i < spawnPoints.size(); i++) {
			if(spawnPoints.get(i).depth > p.depth) {
				spawnPoints.add(i, p);
				i = spawnPoints.size();
			}
		}
		
		if(spawnPointsSize == spawnPoints.size()) {
			spawnPoints.add(p);
		}
	}
	
	
	
}
